<?php

/** @var yii\web\View $this */

use yii\helpers\Url;

$this->title = 'Хим.чистка - Профессиональная чистка на дому';
?>
    <div class="site-index">
        <div class="hero-section text-center">
            <div class="container">
                <h1 class="hero-title">Профессиональная химчистка <span class="highlight">на дому</span></h1>
                <p class="hero-subtitle">Вернем свежесть вашим вещам и мебели с выездом на дом в течение 2 часов</p>

                <div class="hero-advantages">
                    <div class="advantage">
                        <i class="glyphicon glyphicon-time"></i>
                        <span>От 2 часов</span>
                    </div>
                    <div class="advantage">
                        <i class="glyphicon glyphicon-certificate"></i>
                        <span>Гарантия качества</span>
                    </div>
                    <div class="advantage">
                        <i class="glyphicon glyphicon-home"></i>
                        <span>Выезд на дом</span>
                    </div>
                    <div class="advantage">
                        <i class="glyphicon glyphicon-ruble"></i>
                        <span>Без скрытых платежей</span>
                    </div>
                </div>

                <a class="btn btn-order btn-lg" href="<?= Url::toRoute(['order/create']); ?>">Заказать химчистку</a>
            </div>
        </div>
        <section class="services-section">
            <div class="container">
                <h2 class="section-title">Наши <span class="highlight">услуги</span></h2>
                <p class="section-subtitle">Профессиональная чистка любой сложности по доступным ценам</p>

                <div class="row">
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="service-card">
                            <div class="service-icon sofa-icon"></div>
                            <h3>Химчистка диванов</h3>
                            <div class="price">от 1 500 ₽</div>
                            <ul class="service-features">
                                <li>Сухая чистка экстракторным методом</li>
                                <li>Удаление пятен любой сложности</li>
                                <li>Дезинфекция и дезодорация</li>
                                <li>Защита от повторного загрязнения</li>
                            </ul>
                            <a class="btn-service" href="<?= Url::toRoute(['order/create']); ?>">Заказать</a>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="service-card">
                            <div class="service-icon carpet-icon"></div>
                            <h3>Чистка ковров</h3>
                            <div class="price">от 300 ₽/м²</div>
                            <ul class="service-features">
                                <li>Антибактериальная обработка</li>
                                <li>Удаление запахов и пятен</li>
                                <li>Защита от моли и пылевых клещей</li>
                                <li>Восстановление цвета</li>
                            </ul>
                            <a class="btn-service" href="<?= Url::toRoute(['order/create']); ?>">Заказать</a>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="service-card">
                            <div class="service-icon chair-icon"></div>
                            <h3>Чистка кресел</h3>
                            <div class="price">от 1 200 ₽</div>
                            <ul class="service-features">
                                <li>Индивидуальный подбор средств</li>
                                <li>Щадящая чистка деликатных тканей</li>
                                <li>Реставрация изношенных участков</li>
                                <li>Срочная чистка за 3 часа</li>
                            </ul>
                            <a class="btn-service" href="<?= Url::toRoute(['order/create']); ?>">Заказать</a>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="service-card">
                            <div class="service-icon car-icon"></div>
                            <h3>Химчистка салона авто</h3>
                            <div class="price">от 3 500 ₽</div>
                            <ul class="service-features">
                                <li>Комплексная чистка сидений</li>
                                <li>Очистка потолка и панелей</li>
                                <li>Удаление запахов табака</li>
                                <li>Кондиционирование кожи</li>
                            </ul>
                            <a class="btn-service" href="<?= Url::toRoute(['order/create']); ?>">Заказать</a>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="service-card">
                            <div class="service-icon mattress-icon"></div>
                            <h3>Чистка матрасов</h3>
                            <div class="price">от 2 000 ₽</div>
                            <ul class="service-features">
                                <li>Глубокая чистка от пылевых клещей</li>
                                <li>Удаление пятен и запахов</li>
                                <li>Антиаллергенная обработка</li>
                                <li>Сушка до полного высыхания</li>
                            </ul>
                            <a class="btn-service" href="<?= Url::toRoute(['order/create']); ?>">Заказать</a>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="service-card">
                            <div class="service-icon curtain-icon"></div>
                            <h3>Чистка штор и гардин</h3>
                            <div class="price">от 400 ₽/шт</div>
                            <ul class="service-features">
                                <li>Ручная чистка деликатных тканей</li>
                                <li>Сохранение цвета и формы</li>
                                <li>Глажка и вешание на место</li>
                                <li>Срочная чистка за 24 часа</li>
                            </ul>
                            <a class="btn-service" href="<?= Url::toRoute(['order/create']); ?>">Заказать</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Секция преимуществ -->
        <section class="advantages-section">
            <div class="container">
                <h2 class="section-title">Почему выбирают <span class="highlight">нас</span></h2>

                <div class="row">
                    <div class="col-lg-3 col-md-6 mb-4">
                        <div class="advantage-card">
                            <div class="advantage-icon">
                                <i class="glyphicon glyphicon-leaf"></i>
                            </div>
                            <h4>Экологичные средства</h4>
                            <p>Используем только безопасные биоразлагаемые средства, не вызывающие аллергию</p>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-6 mb-4">
                        <div class="advantage-card">
                            <div class="advantage-icon">
                                <i class="glyphicon glyphicon-user"></i>
                            </div>
                            <h4>Опытные мастера</h4>
                            <p>Специалисты с опытом от 5 лет, прошедшие профессиональное обучение</p>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-6 mb-4">
                        <div class="advantage-card">
                            <div class="advantage-icon">
                                <i class="glyphicon glyphicon-shield"></i>
                            </div>
                            <h4>Гарантия 1 год</h4>
                            <p>Даем гарантию на все виды работ и бесплатный выезд при обнаружении недостатков</p>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-6 mb-4">
                        <div class="advantage-card">
                            <div class="advantage-icon">
                                <i class="glyphicon glyphicon-time"></i>
                            </div>
                            <h4>Работаем 24/7</h4>
                            <p>Принимаем заявки круглосуточно, выезжаем в день обращения</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="contacts-section">
            <div class="container">
                <h2 class="section-title">Наши <span class="highlight">контакты</span></h2>

                <div class="row">
                    <div class="col-lg-6 mb-4">
                        <div class="contact-info">
                            <h3><i class="glyphicon glyphicon-map-marker"></i> Адрес</h3>
                            <p>г. Москва, ул. Примерная, д. 123, офис 45</p>

                            <h3><i class="glyphicon glyphicon-time"></i> Часы работы</h3>
                            <p>Пн-Пт: 9:00 - 21:00</p>
                            <p>Сб-Вс: 10:00 - 20:00</p>

                            <h3><i class="glyphicon glyphicon-earphone"></i> Телефоны</h3>
                            <p>8 (800) 123-45-67 - бесплатный звонок</p>
                            <p>8 (495) 123-45-67 - для Москвы</p>

                            <h3><i class="glyphicon glyphicon-envelope"></i> Email</h3>
                            <p>info@cleanpro.ru</p>
                            <p>support@cleanpro.ru</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </div>

<?php
$css = <<<CSS
/* Основные стили */
.site-index {
    font-family: 'Roboto', sans-serif;
    color: #333;
}

/* Герой-секция */
.hero-section {
    background: linear-gradient(rgba(44, 62, 80, 0.9), rgba(52, 152, 219, 0.9)),
                url('https://images.unsplash.com/photo-1586023492125-27b2c045efd7?ixlib=rb-1.2.1&auto=format&fit=crop&w=1920&q=80');
    background-size: cover;
    background-position: center;
    color: white;
    padding: 100px 20px;
    text-align: center;
}

.hero-title {
    font-size: 3.5rem;
    font-weight: 700;
    margin-bottom: 20px;
    text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
}

.hero-title .highlight {
    color: #83c5be;
}

.hero-subtitle {
    font-size: 1.3rem;
    margin-bottom: 40px;
    max-width: 800px;
    margin-left: auto;
    margin-right: auto;
    opacity: 0.9;
}

.hero-advantages {
    display: flex;
    justify-content: center;
    flex-wrap: wrap;
    gap: 30px;
    margin: 40px 0;
}

.advantage {
    display: flex;
    flex-direction: column;
    align-items: center;
    min-width: 150px;
}

.advantage i {
    font-size: 2.5rem;
    color: #83c5be;
    margin-bottom: 10px;
}

.advantage span {
    font-size: 1rem;
    font-weight: 500;
}

.btn-order {
    background: linear-gradient(90deg, #27ae60, #2ecc71);
    border: none;
    border-radius: 30px;
    padding: 18px 50px;
    font-size: 1.2rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
    color: white;
    transition: all 0.3s ease;
    box-shadow: 0 5px 20px rgba(39, 174, 96, 0.3);
}

.btn-order:hover {
    background: linear-gradient(90deg, #229954, #27ae60);
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(39, 174, 96, 0.4);
    color: white;
}

/* Общие стили секций */
.section-title {
    text-align: center;
    color: #2c3e50;
    font-weight: 700;
    margin-bottom: 15px;
    position: relative;
    padding-bottom: 15px;
}

.section-title:after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 50%;
    transform: translateX(-50%);
    width: 80px;
    height: 4px;
    background: linear-gradient(90deg, #3498db, #83c5be);
    border-radius: 2px;
}

.section-title .highlight {
    color: #3498db;
}

.section-subtitle {
    text-align: center;
    color: #666;
    margin-bottom: 50px;
    font-size: 1.1rem;
}

/* Карточки услуг */
.services-section {
    padding: 80px 0;
    background: #f8fafc;
}

.service-card {
    background: white;
    border-radius: 15px;
    padding: 30px;
    height: 100%;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
    border: 2px solid transparent;
    position: relative;
    overflow: hidden;
}

.service-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 20px 40px rgba(52, 152, 219, 0.15);
    border-color: #3498db;
}

.service-card:before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 5px;
    background: linear-gradient(90deg, #3498db, #83c5be);
}

.service-icon {
    width: 80px;
    height: 80px;
    margin: 0 auto 20px;
    background-size: contain;
    background-repeat: no-repeat;
    background-position: center;
}

.sofa-icon { background-image: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="%233498db"><path d="M7 14c1.66 0 3-1.34 3-3S8.66 8 7 8s-3 1.34-3 3 1.34 3 3 3zm0-4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm12-3h-8v8H3V5H1v15h2v-3h18v3h2v-9c0-2.21-1.79-4-4-4zm2 8h-8V9h6c1.1 0 2 .9 2 2v4z"/></svg>'); }
.carpet-icon { background-image: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="%2327ae60"><path d="M12 6c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2m0 10c2.7 0 5.8 1.29 6 2H6c.23-.72 3.31-2 6-2m0-12C9.79 4 8 5.79 8 8s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 10c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/></svg>'); }
.chair-icon { background-image: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="%23e74c3c"><path d="M7 11v2h10v-2c0-1.86 1.28-3.41 3-3.86V6c0-1.65-1.35-3-3-3H7C5.35 3 4 4.35 4 6v1.14c1.72.45 3 2 3 3.86z"/><path d="M21 9c-1.1 0-2 .9-2 2v4H5v-4c0-1.1-.9-2-2-2s-2 .9-2 2v5c0 1.65 1.35 3 3 3v1h2v-1h12v1h2v-1c1.65 0 3-1.35 3-3v-5c0-1.1-.9-2-2-2z"/></svg>'); }
.car-icon { background-image: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="%239b59b6"><path d="M18.92 6.01C18.72 5.42 18.16 5 17.5 5h-11c-.66 0-1.21.42-1.42 1.01L3 12v8c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-1h12v1c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-8l-2.08-5.99zM6.5 16c-.83 0-1.5-.67-1.5-1.5S5.67 13 6.5 13s1.5.67 1.5 1.5S7.33 16 6.5 16zm11 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM5 11l1.5-4.5h11L19 11H5z"/></svg>'); }
.mattress-icon { background-image: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="%23f39c12"><path d="M20 9V6c0-1.1-.9-2-2-2H6c-1.1 0-2 .9-2 2v3c-1.1 0-2 .9-2 2v5c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2v-5c0-1.1-.9-2-2-2zm-8 10c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zm6-10H6V6h12v3z"/></svg>'); }
.curtain-icon { background-image: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="%231abc9c"><path d="M20 19V3H4v16H2v2h20v-2h-2zM18 5v6H6V5h12zM6 19v-6h5v1.82A1.746 1.746 0 0 0 12 18a1.746 1.746 0 0 0 1-3.18V13h5v6H6z"/></svg>'); }

.service-card h3 {
    color: #2c3e50;
    font-weight: 600;
    text-align: center;
    margin-bottom: 15px;
    font-size: 1.5rem;
}

.price {
    text-align: center;
    font-size: 2rem;
    font-weight: 700;
    color: #27ae60;
    margin: 20px 0;
}

.price:before {
    content: 'от ';
    font-size: 1rem;
    color: #7f8c8d;
}

.service-features {
    list-style: none;
    padding: 0;
    margin: 25px 0;
}

.service-features li {
    padding: 8px 0;
    padding-left: 30px;
    position: relative;
    color: #555;
    line-height: 1.5;
}

.service-features li:before {
    content: '✓';
    position: absolute;
    left: 0;
    color: #27ae60;
    font-weight: bold;
    font-size: 1.1rem;
}

.btn-service {
    display: block;
    width: 100%;
    background: #3498db;
    color: white;
    text-align: center;
    padding: 12px;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 500;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.btn-service:hover {
    background: #2980b9;
    color: white;
    text-decoration: none;
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(52, 152, 219, 0.3);
}

/* Секция преимуществ */
.advantages-section {
    padding: 80px 0;
    background: white;
}

.advantage-card {
    text-align: center;
    padding: 30px 20px;
    height: 100%;
}

.advantage-icon {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, #3498db, #83c5be);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 20px;
    color: white;
    font-size: 32px;
    box-shadow: 0 5px 15px rgba(52, 152, 219, 0.2);
}

.advantage-card h4 {
    color: #2c3e50;
    font-weight: 600;
    margin-bottom: 15px;
    font-size: 1.2rem;
}

.advantage-card p {
    color: #666;
    line-height: 1.6;
}

.cta-box {
    background: linear-gradient(135deg, #2c3e50, #4a6572);
    color: white;
    padding: 40px;
    border-radius: 15px;
    text-align: center;
    margin-top: 60px;
}

.cta-box h3 {
    font-size: 1.8rem;
    margin-bottom: 15px;
}

.cta-box p {
    font-size: 1.1rem;
    opacity: 0.9;
    margin-bottom: 25px;
}

.btn-cta {
    display: inline-flex;
    align-items: center;
    background: #27ae60;
    color: white;
    padding: 15px 30px;
    border-radius: 30px;
    text-decoration: none;
    font-weight: 600;
    font-size: 1.1rem;
    transition: all 0.3s ease;
}

.btn-cta i {
    margin-right: 10px;
    font-size: 1.2rem;
}

.btn-cta:hover {
    background: #229954;
    color: white;
    text-decoration: none;
    transform: translateY(-3px);
    box-shadow: 0 5px 20px rgba(39, 174, 96, 0.3);
}

/* Секция контактов */
.contacts-section {
    padding: 80px 0;
    background: #f8fafc;
}

.contact-info, .contact-form {
    background: white;
    padding: 40px;
    border-radius: 15px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
    height: 100%;
}

.contact-info h3, .contact-form h3 {
    color: #2c3e50;
    margin-bottom: 15px;
    display: flex;
    align-items: center;
    font-weight: 600;
}

.contact-info h3 i {
    margin-right: 10px;
    color: #3498db;
}

.contact-info p {
    color: #555;
    margin-bottom: 25px;
    font-size: 1rem;
    line-height: 1.6;
}

.contact-form h3 {
    color: #2c3e50;
    margin-bottom: 10px;
}

.contact-form p {
    color: #666;
    margin-bottom: 30px;
}

.form-control {
    border: 2px solid #e0e0e0;
    border-radius: 10px;
    padding: 12px 15px;
    font-size: 1rem;
    margin-bottom: 20px;
    transition: all 0.3s ease;
}

.form-control:focus {
    border-color: #3498db;
    box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.15);
}

.btn-submit {
    background: linear-gradient(90deg, #3498db, #2980b9);
    color: white;
    border: none;
    padding: 15px 30px;
    border-radius: 10px;
    font-weight: 600;
    width: 100%;
    font-size: 1.1rem;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.btn-submit:hover {
    background: linear-gradient(90deg, #2980b9, #1c5a7f);
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(52, 152, 219, 0.3);
}

/* Адаптивность */
@media (max-width: 992px) {
    .hero-title {
        font-size: 2.8rem;
    }
    
    .hero-advantages {
        gap: 20px;
    }
    
    .advantage {
        min-width: 130px;
    }
}

@media (max-width: 768px) {
    .hero-section {
        padding: 60px 20px;
    }
    
    .hero-title {
        font-size: 2.2rem;
    }
    
    .hero-subtitle {
        font-size: 1.1rem;
    }
    
    .hero-advantages {
        flex-direction: column;
        gap: 25px;
    }
    
    .advantage {
        flex-direction: row;
        min-width: auto;
    }
    
    .advantage i {
        margin-right: 15px;
        margin-bottom: 0;
        font-size: 2rem;
    }
    
    .services-section,
    .advantages-section,
    .contacts-section {
        padding: 60px 0;
    }
    
    .service-card,
    .contact-info,
    .contact-form {
        padding: 25px;
    }
    
    .cta-box {
        padding: 30px 20px;
    }
}

@media (max-width: 576px) {
    .hero-title {
        font-size: 1.8rem;
    }
    
    .btn-order {
        padding: 15px 30px;
        font-size: 1rem;
    }
    
    .price {
        font-size: 1.8rem;
    }
    
    .service-card h3 {
        font-size: 1.3rem;
    }
}

/* Анимации */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.service-card, .advantage-card, .contact-info, .contact-form {
    animation: fadeInUp 0.6s ease-out;
}
CSS;

$this->registerCss($css);
?>