<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $order app\models\Order */
/* @var $orderDetails app\models\OrderDetail[] */

$this->title = 'Заявка #' . $order->id;
$this->params['breadcrumbs'][] = ['label' => 'Мои заявки', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="order-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <div class="row">
        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading">Основная информация</div>
                <div class="panel-body">
                    <?= DetailView::widget([
                        'model' => $order,
                        'attributes' => [
                            'id',
                            [
                                'attribute' => 'service_id',
                                'value' => $order->service ? $order->service->name : 'Не указано',
                            ],
                            'address',
                            [
                                'attribute' => 'payment_method',
                                'value' => $order->getPaymentMethodText(),
                            ],
                            [
                                'attribute' => 'status',
                                'value' => $order->getStatusText(),
                                'format' => 'raw',
                                'value' => function($model) {
                                    $statusClass = [
                                        'pending' => 'label-warning',
                                        'confirmed' => 'label-info',
                                        'in_progress' => 'label-primary',
                                        'completed' => 'label-success',
                                        'cancelled' => 'label-danger',
                                    ];
                                    return '<span class="label ' . ($statusClass[$model->status] ?? 'label-default') . '">' .
                                        $model->getStatusText() . '</span>';
                                },
                            ],
                            'created_at',
                        ],
                    ]) ?>
                </div>
            </div>
        </div>
    </div>

    <?php if (!empty($orderDetails)): ?>
        <div class="panel panel-default">
            <div class="panel-heading">Детали услуги</div>
            <div class="panel-body">
                <table class="table table-bordered">
                    <thead>
                    <tr>
                        <th>Параметр</th>
                        <th>Значение</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($orderDetails as $detail): ?>
                        <div class="order-detail">

                            <?php if (isset($attributes[$detail->attribute_id])): ?>
                                <strong><?= Html::encode($attributes[$detail->attribute_id]->attribute_name) ?>:</strong>
                            <?php else: ?>
                                <strong>Атрибут #<?= $detail->attribute_id ?>:</strong>
                            <?php endif; ?>

                            <?= Html::encode($detail->value) ?>
                        </div>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>

    <div class="form-group">
        <?= Html::a('Вернуться к списку', ['index'], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Создать новую заявку', ['create'], ['class' => 'btn btn-success']) ?>
    </div>

</div>