<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use app\models\Order;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */
/* @var $orders app\models\Order[] */

$this->title = 'Мои заявки';
$this->params['breadcrumbs'][] = $this->title;
?>
    <div class="order-index">

        <h1><?= Html::encode($this->title) ?></h1>

        <?php if (Yii::$app->session->hasFlash('success')): ?>
            <div class="alert alert-success">
                <?= Yii::$app->session->getFlash('success') ?>
            </div>
        <?php endif; ?>

        <?php if (empty($orders)): ?>
            <div class="jumbotron">
                <h2><i class="glyphicon glyphicon-inbox"></i> У вас пока нет заявок</h2>
                <p>Вы еще не создавали заявок на химчистку. Создайте свою первую заявку!</p>
                <p><?= Html::a('<i class="glyphicon glyphicon-plus"></i> Создать заявку', ['create'], ['class' => 'btn btn-success btn-lg']) ?></p>
            </div>
        <?php else: ?>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                            <tr>
                                <th>№ заявки</th>
                                <th>Услуга</th>
                                <th>Дата создания</th>
                                <th>Статус</th>
                                <th>Адрес</th>
                                <th>Способ оплаты</th>
                                <th>Действия</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($orders as $order): ?>
                                <tr>
                                    <td>
                                        <strong>#<?= $order->id ?></strong>
                                    </td>
                                    <td>
                                        <?= Html::encode($order->service ? $order->service->name : 'Не указано') ?>
                                    </td>
                                    <td>
                                        <?= Yii::$app->formatter->asDatetime($order->created_at, 'php:d.m.Y H:i') ?>
                                    </td>
                                    <td>
                                        <?php
                                        $statusClass = [
                                            Order::STATUS_PENDING => 'warning',
                                            Order::STATUS_CONFIRMED => 'info',
                                            Order::STATUS_IN_PROGRESS => 'primary',
                                            Order::STATUS_COMPLETED => 'success',
                                            Order::STATUS_CANCELLED => 'danger',
                                        ];
                                        $class = $statusClass[$order->status] ?? 'default';
                                        ?>
                                        <span class="label label-<?= $class ?>">
                                        <?= $order->getStatusText() ?>
                                    </span>
                                    </td>
                                    <td>
                                        <?= Html::encode(mb_substr($order->address, 0, 50) . (mb_strlen($order->address) > 50 ? '...' : '')) ?>
                                    </td>
                                    <td>
                                        <?= $order->getPaymentMethodText() ?>
                                    </td>
                                    <td>
                                        <?= Html::a('<i class="glyphicon glyphicon-eye-open"></i> Просмотр',
                                            ['view', 'id' => $order->id],
                                            ['class' => 'btn btn-primary btn-xs']) ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <i class="glyphicon glyphicon-info-sign"></i> Статусы заявок
                        </div>
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-md-2 text-center">
                                    <span class="label label-warning">Новая</span>
                                    <p class="small">Заявка создана, ожидает подтверждения</p>
                                </div>
                                <div class="col-md-2 text-center">
                                    <span class="label label-info">Подтверждена</span>
                                    <p class="small">Заявка подтверждена менеджером</p>
                                </div>
                                <div class="col-md-2 text-center">
                                    <span class="label label-primary">В работе</span>
                                    <p class="small">Мастер выехал по адресу</p>
                                </div>
                                <div class="col-md-2 text-center">
                                    <span class="label label-success">Выполнена</span>
                                    <p class="small">Услуга оказана, заявка закрыта</p>
                                </div>
                                <div class="col-md-2 text-center">
                                    <span class="label label-danger">Отменена</span>
                                    <p class="small">Заявка отменена</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="form-group">
            <?= Html::a('<i class="glyphicon glyphicon-plus"></i> Создать новую заявку', ['create'], ['class' => 'btn btn-success']) ?>
            <?= Html::a('<i class="glyphicon glyphicon-home"></i> На главную', ['site/index'], ['class' => 'btn btn-default']) ?>
        </div>

    </div>

<?php
$css = <<<CSS
.order-index .jumbotron {
    background-color: #f8f9fa;
    padding: 30px;
    border-radius: 10px;
    text-align: center;
}

.order-index .table {
    background-color: white;
}

.order-index .table th {
    background-color: #f5f5f5;
    font-weight: bold;
}

.order-index .table tbody tr:hover {
    background-color: #f9f9f9;
}

.order-index .label {
    font-size: 12px;
    padding: 5px 10px;
    border-radius: 3px;
}

.order-index .btn-xs {
    padding: 3px 8px;
    font-size: 12px;
    margin-right: 5px;
}

.order-index .panel-body .col-md-2 {
    margin-bottom: 15px;
}

.order-index .panel-body .small {
    margin-top: 5px;
    color: #666;
}
CSS;

$this->registerCss($css);
?>