<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use app\models\Service;
use app\models\OrderForm;

/* @var $this yii\web\View */
/* @var $model app\models\OrderForm */
/* @var $serviceList array */

$this->title = 'Оформление заявки на химчистку';
$this->params['breadcrumbs'][] = ['label' => 'Заявки', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

// Если пользователь авторизован
$user = Yii::$app->user->identity;
?>
    <div class="order-create">

        <h1><?= Html::encode($this->title) ?></h1>

        <?php if (Yii::$app->session->hasFlash('success')): ?>
            <div class="alert alert-success">
                <?= Yii::$app->session->getFlash('success') ?>
            </div>
        <?php endif; ?>

        <?php if (Yii::$app->session->hasFlash('error')): ?>
            <div class="alert alert-danger">
                <?= Yii::$app->session->getFlash('error') ?>
            </div>
        <?php endif; ?>

        <div class="order-form">
            <?php $form = ActiveForm::begin([
                'id' => 'order-form',
                'enableClientValidation' => true,
                'enableAjaxValidation' => true,
                'validateOnChange' => false,
                'validateOnBlur' => false,
                'validationUrl' => ['order/validate'],
                'options' => ['class' => 'form-horizontal'],
            ]); ?>

            <!-- Общие поля -->
            <div class="row">
                <div class="col-md-6">
                    <?= $form->field($model, 'service_id')->dropDownList(
                        $serviceList,
                        [
                            'prompt' => 'Выберите категорию...',
                            'id' => 'service-category',
                            'class' => 'form-control'
                        ]
                    )->label('Категория услуги') ?>
                </div>
            </div>

            <!-- Поля для авторизованных пользователей -->
            <?php if ($user): ?>
                <div class="alert alert-info">
                    <i class="glyphicon glyphicon-user"></i> Вы авторизованы как: <?= Html::encode($user->surname . ' ' . $user->name) ?>
                </div>
                <?= $form->field($model, 'user_id')->hiddenInput(['value' => $user->id])->label(false) ?>
            <?php else: ?>
                <div class="alert alert-warning">
                    <i class="glyphicon glyphicon-info-sign"></i>
                    <a href="<?= \yii\helpers\Url::to(['/site/login']) ?>" class="alert-link">Войдите</a> или
                    <a href="<?= \yii\helpers\Url::to(['/site/signup']) ?>" class="alert-link">зарегистрируйтесь</a>
                    для быстрого оформления заказа и отслеживания статуса.
                </div>
            <?php endif; ?>

            <!-- Динамические поля (появятся при выборе категории) -->
            <div id="dynamic-fields"></div>

            <!-- Статические поля -->
            <div class="row">
                <div class="col-md-12">
                    <?= $form->field($model, 'address')->textarea([
                        'rows' => 3,
                        'placeholder' => 'Укажите полный адрес для оказания услуги, включая подъезд и этаж'
                    ])->label('Адрес проживания') ?>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <?= $form->field($model, 'payment_method')->radioList(
                        OrderForm::getPaymentMethods(),
                        [
                            'class' => 'payment-methods',
                            'item' => function($index, $label, $name, $checked, $value) {
                                $checked = $checked ? 'checked' : '';
                                $id = 'payment_' . $value;
                                return '<div class="radio">
                                <label>
                                    <input type="radio" name="' . $name . '" value="' . $value . '" id="' . $id . '" ' . $checked . '>
                                    ' . $label . '
                                </label>
                            </div>';
                            }
                        ]
                    )->label('Способ оплаты') ?>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="panel panel-default">
                        <div class="panel-heading">Дополнительная информация</div>
                        <div class="panel-body">
                            <?= $form->field($model, 'has_additional_info')->checkbox([
                                'id' => 'additional-info-checkbox',
                                'label' => 'У меня есть дополнительные пожелания или информация по услуге'
                            ]) ?>

                            <?= $form->field($model, 'additional_info')->textarea([
                                'rows' => 4,
                                'id' => 'additional-info-field',
                                'placeholder' => 'Например: особые пятна, аллергия на химию, предпочтительное время визита и т.д.',
                                'style' => 'display: none;'
                            ])->label(false) ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="col-md-12">
                    <?= Html::submitButton('<i class="glyphicon glyphicon-send"></i> Отправить заявку', [
                        'class' => 'btn btn-success btn-lg btn-block',
                        'name' => 'order-button'
                    ]) ?>
                </div>
            </div>

            <div class="alert alert-info">
                <h4><i class="glyphicon glyphicon-time"></i> Что происходит после отправки заявки?</h4>
                <ol>
                    <li>Вы получите уведомление о принятии заявки</li>
                    <li>С вами свяжется наш менеджер для уточнения деталей</li>
                    <li>Мы согласуем удобное время для оказания услуги</li>
                    <li>Мастер приедет по указанному адресу</li>
                </ol>
            </div>

            <?php ActiveForm::end(); ?>
        </div>

    </div>

<?php
$js = <<<JS
// Предотвращаем отправку формы при изменении select
$(document).on('change', '#service-category', function(e) {
    e.preventDefault();
    e.stopPropagation();
    
    var serviceId = $(this).val();
    var dynamicFields = $('#dynamic-fields');
    
    if (!serviceId) {
        dynamicFields.html('<div class="alert alert-info">Выберите категорию услуги</div>');
        return false;
    }
    
    dynamicFields.html('<div class="text-center"><i class="glyphicon glyphicon-refresh glyphicon-spin"></i> Загрузка...</div>');
    
    // Используем абсолютный URL
    var url = window.location.pathname.replace('/create', '/get-attributes') + '?service_id=' + serviceId;
    
    // Если мы на странице /order/create, меняем на /order/get-attributes
    if (url.indexOf('/order/create') !== -1) {
        url = url.replace('/order/create', '/order/get-attributes');
    }
    
    console.log('AJAX запрос к:', url);
    
    $.ajax({
        url: url,
        type: 'GET',
        dataType: 'html',
        cache: false,
        success: function(response) {
            console.log('Успешно получены поля');
            dynamicFields.html(response);
        },
        error: function(xhr, status, error) {
            console.error('AJAX ошибка:', status, error);
            
            // Показываем статические поля в случае ошибки
            showStaticFields(serviceId);
        }
    });
    
    return false;
});

// Функция для показа статических полей
function showStaticFields(serviceId) {
    var dynamicFields = $('#dynamic-fields');
    var fieldsHtml = '';
    
    switch(parseInt(serviceId)) {
        case 1: // Обувь
            fieldsHtml = `
            <div class="form-group">
                <label class="control-label">Вид обуви *</label>
                <select class="form-control" name="OrderForm[attributes][вид_обуви]" required>
                    <option value="">Выберите...</option>
                    <option value="Кроссовки">Кроссовки</option>
                    <option value="Туфли">Туфли</option>
                    <option value="Сапоги">Сапоги</option>
                    <option value="Ботинки">Ботинки</option>
                </select>
            </div>
            <div class="form-group">
                <label class="control-label">Материал обуви *</label>
                <select class="form-control" name="OrderForm[attributes][материал_обуви]" required>
                    <option value="">Выберите...</option>
                    <option value="Кожа">Кожа</option>
                    <option value="Замша">Замша</option>
                    <option value="Текстиль">Текстиль</option>
                    <option value="Резина">Резина</option>
                </select>
            </div>`;
            break;
            
        case 2: // Верхняя одежда
            fieldsHtml = `
            <div class="form-group">
                <label class="control-label">Вид одежды *</label>
                <select class="form-control" name="OrderForm[attributes][вид_одежды]" required>
                    <option value="">Выберите...</option>
                    <option value="Пальто">Пальто</option>
                    <option value="Куртка">Куртка</option>
                    <option value="Плащ">Плащ</option>
                    <option value="Пуховик">Пуховик</option>
                    <option value="Шуба">Шуба</option>
                </select>
            </div>
            <div class="form-group">
                <label class="control-label">Материал одежды *</label>
                <select class="form-control" name="OrderForm[attributes][материал_одежды]" required>
                    <option value="">Выберите...</option>
                    <option value="Шерсть">Шерсть</option>
                    <option value="Хлопок">Хлопок</option>
                    <option value="Синтетика">Синтетика</option>
                    <option value="Кожа">Кожа</option>
                    <option value="Замша">Замша</option>
                </select>
            </div>`;
            break;
            
        case 3: // Мягкая мебель
            fieldsHtml = `
            <div class="form-group">
                <label class="control-label">Вид мебели *</label>
                <select class="form-control" name="OrderForm[attributes][вид_мебели]" required>
                    <option value="">Выберите...</option>
                    <option value="Диван">Диван</option>
                    <option value="Кресло">Кресло</option>
                    <option value="Кровать">Кровать</option>
                    <option value="Стул">Стул</option>
                </select>
            </div>
            <div class="form-group">
                <label class="control-label">Материал мебели *</label>
                <select class="form-control" name="OrderForm[attributes][материал_мебели]" required>
                    <option value="">Выберите...</option>
                    <option value="Ткань">Ткань</option>
                    <option value="Кожа">Кожа</option>
                    <option value="Искусственная кожа">Искусственная кожа</option>
                </select>
            </div>
            <div class="form-group">
                <label class="control-label">Степень загрязнения *</label>
                <select class="form-control" name="OrderForm[attributes][степень_загрязнения]" required>
                    <option value="">Выберите...</option>
                    <option value="Легкое">Легкое</option>
                    <option value="Среднее">Среднее</option>
                    <option value="Сильное">Сильное</option>
                </select>
            </div>`;
            break;
            
        case 4: // Ковровые покрытия
            fieldsHtml = `
            <div class="form-group">
                <label class="control-label">Размер ковра *</label>
                <input type="text" class="form-control" name="OrderForm[attributes][размер_ковра]" 
                       placeholder="Например: 2x3 м" required>
            </div>
            <div class="form-group">
                <label class="control-label">Степень загрязнения *</label>
                <select class="form-control" name="OrderForm[attributes][степень_загрязнения]" required>
                    <option value="">Выберите...</option>
                    <option value="Легкое">Легкое</option>
                    <option value="Среднее">Среднее</option>
                    <option value="Сильное">Сильное</option>
                </select>
            </div>
            <div class="form-group">
                <label class="control-label">Материал ковра *</label>
                <select class="form-control" name="OrderForm[attributes][материал_ковра]" required>
                    <option value="">Выберите...</option>
                    <option value="Шерсть">Шерсть</option>
                    <option value="Синтетика">Синтетика</option>
                    <option value="Хлопок">Хлопок</option>
                    <option value="Смешанный">Смешанный</option>
                </select>
            </div>`;
            break;
            
        default:
            fieldsHtml = '<div class="alert alert-info">Выберите категорию услуги</div>';
    }
    
    dynamicFields.html(fieldsHtml);
}

// При загрузке страницы
$(document).ready(function() {
    // Предотвращаем любую отправку формы кроме кнопки submit
    $('#order-form').on('submit', function(e) {
        var submitter = e.originalEvent.submitter;
        if (!$(submitter).is('[type="submit"]')) {
            e.preventDefault();
        }
    });
    
    // Если уже выбрана категория при загрузке страницы
    var selectedService = $('#service-category').val();
    if (selectedService) {
        setTimeout(function() {
            $('#service-category').trigger('change');
        }, 500);
    }
    
    // Обработка чекбокса дополнительной информации
    $('#additional-info-checkbox').on('change', function() {
        if ($(this).is(':checked')) {
            $('#additional-info-field').slideDown(300).prop('required', true);
        } else {
            $('#additional-info-field').slideUp(300).prop('required', false).val('');
        }
    });
});
JS;

$this->registerJs($js);
?>