<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "service_attributes".
 *
 * @property int $id
 * @property int $service_id
 * @property string $attribute_name
 * @property string $attribute_type
 *
 * @property AttributeOption[] $attributeOptions
 * @property OrderDetail[] $orderDetails
 * @property Service $service
 */
class ServiceAttribute extends \yii\db\ActiveRecord
{

    /**
     * ENUM field values
     */
    const ATTRIBUTE_TYPE_TEXT = 'text';
    const ATTRIBUTE_TYPE_SELECT = 'select';
    const ATTRIBUTE_TYPE_NUMBER = 'number';
    const ATTRIBUTE_TYPE_CHECKBOX = 'checkbox';

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'service_attributes';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['service_id', 'attribute_name', 'attribute_type'], 'required'],
            [['service_id'], 'integer'],
            [['attribute_type'], 'string'],
            [['attribute_name'], 'string', 'max' => 100],
            ['attribute_type', 'in', 'range' => array_keys(self::optsAttributeType())],
            [['service_id'], 'exist', 'skipOnError' => true, 'targetClass' => Service::class, 'targetAttribute' => ['service_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'service_id' => 'Сервис',
            'attribute_name' => 'Название',
            'attribute_type' => 'Тип',
        ];
    }

    /**
     * Gets query for [[AttributeOption]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getAttributeOptions()
    {
        return $this->hasMany(AttributeOption::class, ['attribute_id' => 'id']);
    }

    /**
     * Gets query for [[OrderDetail]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOrderDetails()
    {
        return $this->hasMany(OrderDetail::class, ['attribute_id' => 'id']);
    }

    /**
     * Gets query for [[Service]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getService()
    {
        return $this->hasOne(Service::class, ['id' => 'service_id']);
    }


    /**
     * column attribute_type ENUM value labels
     * @return string[]
     */
    public static function optsAttributeType()
    {
        return [
            self::ATTRIBUTE_TYPE_TEXT => 'text',
            self::ATTRIBUTE_TYPE_SELECT => 'select',
            self::ATTRIBUTE_TYPE_NUMBER => 'number',
            self::ATTRIBUTE_TYPE_CHECKBOX => 'checkbox',
        ];
    }

    /**
     * @return string
     */
    public function displayAttributeType()
    {
        return self::optsAttributeType()[$this->attribute_type];
    }

    /**
     * @return bool
     */
    public function isAttributeTypeText()
    {
        return $this->attribute_type === self::ATTRIBUTE_TYPE_TEXT;
    }

    public function setAttributeTypeToText()
    {
        $this->attribute_type = self::ATTRIBUTE_TYPE_TEXT;
    }

    /**
     * @return bool
     */
    public function isAttributeTypeSelect()
    {
        return $this->attribute_type === self::ATTRIBUTE_TYPE_SELECT;
    }

    public function setAttributeTypeToSelect()
    {
        $this->attribute_type = self::ATTRIBUTE_TYPE_SELECT;
    }

    /**
     * @return bool
     */
    public function isAttributeTypeNumber()
    {
        return $this->attribute_type === self::ATTRIBUTE_TYPE_NUMBER;
    }

    public function setAttributeTypeToNumber()
    {
        $this->attribute_type = self::ATTRIBUTE_TYPE_NUMBER;
    }

    /**
     * @return bool
     */
    public function isAttributeTypeCheckbox()
    {
        return $this->attribute_type === self::ATTRIBUTE_TYPE_CHECKBOX;
    }

    public function setAttributeTypeToCheckbox()
    {
        $this->attribute_type = self::ATTRIBUTE_TYPE_CHECKBOX;
    }
}
