<?php

namespace app\models;

use Yii;
use yii\base\Model;

class OrderForm extends Model
{
    public $service_id;
    public $user_id;
    public $address;
    public $payment_method = 'cash';
    public $has_additional_info = 0;
    public $additional_info;
    public $attributes = [];

    public function rules()
    {
        return [
            [['service_id', 'address', 'payment_method'], 'required', 'message' => 'Это поле обязательно для заполнения'],
            ['service_id', 'integer'],
            ['user_id', 'integer'],
            ['address', 'string', 'min' => 10, 'tooShort' => 'Адрес должен содержать минимум 10 символов'],
            ['address', 'string', 'max' => 500, 'tooLong' => 'Адрес не должен превышать 500 символов'],
            ['payment_method', 'in', 'range' => ['cash', 'card']],
            ['has_additional_info', 'boolean'],
            ['has_additional_info', 'default', 'value' => 0],
            ['additional_info', 'string', 'max' => 1000],
            ['additional_info', 'required',
                'when' => function($model) {
                    return $model->has_additional_info == 1;
                },
                'message' => 'Пожалуйста, укажите дополнительную информацию'
            ],
            ['attributes', 'safe'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'service_id' => 'Категория услуги',
            'address' => 'Адрес проживания',
            'payment_method' => 'Способ оплаты',
            'has_additional_info' => 'Дополнительная информация по услуге',
            'additional_info' => 'Дополнительные сведения',
        ];
    }

    public static function getPaymentMethods()
    {
        return [
            'cash' => 'Наличный расчет',
            'card' => 'Безналичный расчет'
        ];
    }
}