<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "attribute_options".
 *
 * @property int $id
 * @property int $attribute_id
 * @property string $option_value
 *
 * @property ServiceAttribute $attribute0
 */
class AttributeOption extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'attribute_options';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['attribute_id', 'option_value'], 'required'],
            [['attribute_id'], 'integer'],
            [['option_value'], 'string', 'max' => 100],
            [['attribute_id'], 'exist', 'skipOnError' => true, 'targetClass' => ServiceAttribute::class, 'targetAttribute' => ['attribute_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'attribute_id' => 'Аттрибут',
            'option_value' => 'Option Value',
        ];
    }

    /**
     * Gets query for [[Attribute0]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getAttribute0()
    {
        return $this->hasOne(ServiceAttribute::class, ['id' => 'attribute_id']);
    }

}
